 
/***
 * AUTHOR:Orhan Dagdeviren
 * ABOUT: Simple Synchronous Flooding protocol
 */
#include "protocol.h"

char * message_to_string(int message)
{
   if(message==START) return "START";
   if(message==DATA)  return "DATA";
   if(message==END)  return "END";

}

//Flooding Thread implementation
//Works like this;
//While thread working is TRUE
//    Receive a Message From My Buffer
//    Make a transition according to received message
void * thread_impl(void *me)
{
    int my_id=(int)me;
    bufptr buf;
    printf("Thread %d begins... \n",my_id);
    //While thread working is TRUE
    while(thread_working[my_id]==TRUE)
    {
        //Receive a Message From My Buffer
        //Make a transition according to received message 
        //printf("%d is waiting \n",my_id);    
        buf=receive_message(fifos[my_id]);
	printf("%d receives a %s message from %d at round:%d \n",my_id,message_to_string(buf->message_type),buf->source,round_count);       
        transition(my_id,buf);
	put_buf(pools,buf);
    }
    printf("Thread %d exited \n",my_id);
    pthread_exit(0);
}


void transition(int my_id,bufptr buf)
{
  int message_type=buf->message_type;
  
  if(message_type==START && data_sent[my_id]==FALSE)
  {
      if(my_id==0 && round_count==1)
      {
         data_received[my_id]=TRUE;
         data_sent[my_id]=TRUE;
         multicast_to_neighbors(my_id); 
      }
      else if(my_id!=0 && data_received[my_id]==TRUE && data_sent[my_id]==FALSE)
      {
         data_sent[my_id]=TRUE;
         multicast_to_neighbors(my_id); 
      }
  
  }
  else if(message_type==DATA && data_received[my_id]==FALSE)
  {
      data_received[my_id]=TRUE;
      data=buf->data;
  }
  else if(message_type==END)
  {
      printf("%d ends \n",my_id);
      thread_working[my_id]=FALSE;
      
  }
}

void multicast_to_neighbors(int my_id)
{
   int i=0;
   printf("%d multicasts DATA message to its neighbors in round %d \n",my_id,round_count);

   for(i=0;i<N_THREADS;i++)
   {
      if(my_graph.edge[my_id][i]==CONNECTED)
      {
         bufptr buf;
         buf=get_buf(pools);
         prepare_message(buf,my_id,i,DATA);
         send_message(fifos[i],buf);
      }
   }

}

//Join Threads 
void join_threads()
{
  int i=0;
  //Join All the Threads
  for(i=0;i<N_THREADS;i++) pthread_join(threads[i],NULL);
}

void new_round_starter()
{
   round_count++;
   printf("Round:%d is starting  \n",round_count);
   int i;
   int send_message_type=START;
   if(round_count==5) send_message_type=END;

   for(i=0;i<N_THREADS;i++)
   {
      bufptr buf;
      buf=get_buf(pools);
      prepare_message(buf,SYSTEM_THREAD,i,send_message_type);
      send_message(fifos[i],buf);
      //printf("Node 6 sends START to Node %d \n",i);
   }
  
   
   alarm(INTERVAL_TIME);
  
}


//Creates the system processes
//Gets Buffer
//Thread attributes
//Creates threads
//Prepare a message and send
//Join Threads
void start_threads()
{
  
  int i=0;
  //bufptr buf;
  //Gets Buffer
  //buf=get_buf(pools);
  
  //Thread attributes
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setscope(&attr,PTHREAD_SCOPE_SYSTEM);

  for(i=0;i<N_THREADS;i++)
     pthread_create(&threads[i],&attr,thread_impl,(void *)i);
  

  sleep(1);
  round_count=0;

  signal(SIGALRM, new_round_starter);
  alarm(INTERVAL_TIME);

  
  //Join Threads
  join_threads(threads); 
}

//Initializes the System
//Initializes Application Working
//Initializes Current States
//Fifos initiliazed
//Pools initiliazed
void start_sys()
{
  
  int i=0,j=0;
 
  //Application Working
  for(i=0;i<N_THREADS;i++){ 
      thread_working[i]=TRUE;
      data_received[i]=FALSE;
      data_sent[i]=FALSE;
  }
  //thread_working[6]=FALSE;
  
  //Fifos and graph initiliazed
  for(i=0;i<N_THREADS;i++)
  {
       fifos[i]=(fifoptr)malloc(sizeof(fifo_t));
       init_fifo(fifos[i]);
         
       for(j=0;j<N_THREADS;j++)
       {
          my_graph.edge[i][j]=UNCONNECTED;
       }  
  
  }
  printf("Fifos and graph initiliazed...\n");

  my_graph.edge[0][2]=CONNECTED;
  my_graph.edge[0][3]=CONNECTED;

  my_graph.edge[1][0]=CONNECTED;
  my_graph.edge[1][3]=CONNECTED;
  my_graph.edge[1][4]=CONNECTED;

  my_graph.edge[2][0]=CONNECTED;

  my_graph.edge[3][4]=CONNECTED;

  my_graph.edge[4][1]=CONNECTED;
  my_graph.edge[4][5]=CONNECTED;
 
  my_graph.edge[5][2]=CONNECTED;
  my_graph.edge[5][3]=CONNECTED;

  //Pools initiliazed
  pools=(poolptr)malloc(sizeof(pool_t));
  init_pool(pools,POOL_SIZE);
  printf("Pools initiliazed... \n");
  
  //Start Threads
  start_threads();
  
}

//Prepares message buffer
//Sets the source
//Sets the destination
//Sets the message type
void prepare_message(bufptr buf,int source,int destination,int message_type)
{
   buf->source=source;
   buf->destination=destination;
   buf->message_type=message_type;

}












