 

/*******************************************************************************

            Buffer Pool Management

            IPC Using FIFOs

 

            Author : K. Erciyes 

            September 1999

******************************************************************************/


#include "protocol.h"

int ipc_debug_control=0;


 
/*****************************************************************************

                  initialize a pool 

******************************************************************************/
void  init_pool (poolptr pp, int pool_length)

{     int i ;
      pp->pool_size=pool_length;
      sem_init(&pp->poolsem,0,pp->pool_size);
      pthread_mutex_init(&pp->poolmut,NULL);
      pp->front=&(pp->bufs[0]);
            for (i=0; i<pp->pool_size - 1; i ++)
            pp->bufs[i].next = &(pp->bufs[i+1]);
      pp->rear=&(pp->bufs[pp->pool_size-1]);
}

bufptr check_pool(poolptr pp)

{     bufptr bp;
      bp=pp->front;
      return(bp);
}


/*****************************************************************************

                  get a buffer from a pool 

******************************************************************************/
bufptr get_buf(poolptr pp)

{     
      bufptr bp;
      if(ipc_debug_control==1) printf("get buf****** \n");
      sem_wait(&pp->poolsem);
      if(ipc_debug_control==1) printf("p_thread_mutex_lock \n");
      pthread_mutex_lock(&pp->poolmut);
      bp= pp->front;
      pp->front=bp->next;
      pthread_mutex_unlock(&pp->poolmut);   
      if(ipc_debug_control==1) printf("end of get buf----- \n");
      return(bp);
}
/*****************************************************************************

                  put a buffer to a pool 

******************************************************************************/

void put_buf(poolptr pp, bufptr bp)

{     bp->next=NULL;
      if(ipc_debug_control==1) printf("bp->next \n");
      pthread_mutex_lock(&pp->poolmut);
      if(ipc_debug_control==1) printf("pthread_mutex_lock(&pp->poolmut) \n");
      pp->rear->next=bp;
      pp->rear=bp;
      if (pp->front==NULL) pp->front=bp;
      pthread_mutex_unlock(&pp->poolmut);
      if(ipc_debug_control==1) printf("pthread_mutex_unlock(&pp->poolmut) \n");
      sem_post(&pp->poolsem);
}



 

/*****************************************************************************

                  initialize a fifo 

******************************************************************************/

int init_fifo(fifoptr fp)

{     int fifoid=0;
      fp->state=ALLOCATED; 
      fp->fifo_size=FIFO_SIZE;
      sem_init(&fp->fullsem,0,0);
      sem_init(&fp->emptysem,0,fp->fifo_size);
      pthread_mutex_init(&fp->fifomut,NULL);
      fp->read_idx=0;
      fp->write_idx=0;
      return(fifoid);
}

/*****************************************************************************

                  read a buffer from a fifo 

******************************************************************************/
bufptr read_fifo(fifoptr fp)
{     
      bufptr bp;
      if(ipc_debug_control==1) printf("sem_wait(&fp->fullsem) \n");
      sem_wait(&fp->fullsem);
      if(ipc_debug_control==1) printf("sem_wait(&fp->fullsem) \n");
      pthread_mutex_lock(&fp->fifomut);
      if(ipc_debug_control==1) printf("pthread_mutex_lock(&fp->fifomut); \n");
      bp=fp->bufs[fp->read_idx++];
      fp->read_idx %= fp->fifo_size; 
      pthread_mutex_unlock(&fp->fifomut);
      sem_post(&fp->emptysem);
      return bp;
}

/*****************************************************************************

                  write a buffer to a fifo 

******************************************************************************/

void write_fifo(fifoptr fp, bufptr bp)
{     
      sem_wait(&fp->emptysem);
      if(ipc_debug_control==1) printf("Write Fifo sem_wait passed.. \n");
      pthread_mutex_lock(&fp->fifomut);
      if(ipc_debug_control==1) printf("Mutex Lock passed.. \n");
      fp->bufs[fp->write_idx++]=bp;
      if(ipc_debug_control==1) printf("fp->bufs passed.. fp->write_idx: %d fp->fifo_size:%d \n",fp->write_idx,fp->fifo_size);
      fp->write_idx %= fp->fifo_size;   
      if(ipc_debug_control==1) printf("fp->write_idx fp->fifo_size; \n");
      pthread_mutex_unlock(&fp->fifomut);
      if(ipc_debug_control==1) printf("pthread_mutex_unlock(&fp->fifomut); \n");
      sem_post(&fp->fullsem);
      if(ipc_debug_control==1) printf("sem_post(&fp->fullsem); \n"); 
      if(ipc_debug_control==1) printf("write fifo end \n");
}


void send_message(fifoptr fp,bufptr bp)
{
  if(bp->message_type!=START) usleep(10);
     write_fifo(fp,bp);
}

bufptr receive_message(fifoptr fp)
{
  return read_fifo(fp);
}
