/***
 * AUTHOR:Orhan Dagdeviren
 * ABOUT:Definitions and prototypes for synchronous Flooding Algorithm
 * 
 */
 
#include<stdio.h>
#include<pthread.h>
#include<semaphore.h>
#include<malloc.h>
#include <sys/time.h>
#include<unistd.h>
#include<stdlib.h>
#include<signal.h>

//Number of Threads
#define N_THREADS 6

// Id of System Thread
#define SYSTEM_THREAD N_THREADS


//State
#define STATE int

//Working 
#define WORKING 1
//Terminated
#define TERMINATED 0

//Message Types
//Flooding Message Types
#define START   0
#define DATA    1
#define END     2


//True or False
#define TRUE 0
#define FALSE 1

// Unconned or Connected
#define UNCONNECTED 0
#define CONNECTED 1


#define     FIFO_SIZE       10 
#define     N_FIFOS           N_THREADS    
#define     ALLOCATED   1
#define     ERR_FIFOEMPTY     -1
#define     ERR_FIFOFULL      -2
#define     POOL_SIZE   100   /* size of allocated space */
#define     ERR_POOLEMPTY     -1
#define     ERR_POOLFULL      -2

#define INTERVAL_TIME  3


typedef struct buffer_t{
    int data;
    int source;
    int destination;
    int message_type;
    int hop_count;

    struct buffer_t  *next;
} buf_t, *bufptr;

typedef struct com_messages{ 
    int *message;
    int message_size;
    
} com_mes; 

typedef struct fifo *fifoptr;

typedef struct fifo{    
	              int state ;
                  int fifo_size;
                  int read_idx;
                  int write_idx;
                  sem_t  fullsem;
                  sem_t emptysem;
                  pthread_mutex_t fifomut;
                  bufptr bufs[FIFO_SIZE];
                  } fifo_t;

typedef struct fifotable *fifotabptr;

typedef struct fifotable{     
	                    int state ;
                        int curridx;
                        fifoptr fifos[N_FIFOS];
                  } fifotab_t;
                  


typedef struct pool *poolptr;

typedef struct pool{    
	        int state ;
            int pool_size;
            sem_t poolsem;
            pthread_mutex_t poolmut;                    
            bufptr front;
            bufptr rear;
            buf_t bufs[POOL_SIZE];
            } pool_t;

typedef struct graph{
    int edge[N_THREADS][N_THREADS];
} graph_t, *graphptr;
 

//Threads
pthread_t threads[N_THREADS];

fifoptr fifos[N_FIFOS];

poolptr pools;

graph_t my_graph;

//Global Error
int global_error;

int k;
int thread_working[N_THREADS];
int data_sent[N_THREADS];
int data_received[N_THREADS];
int round_count;
int data;
int new_round[N_THREADS];


//IPC Module Prototypes
void  init_pool (poolptr pp, int pool_length);
bufptr check_pool(poolptr pp);
bufptr get_buf(poolptr pp);
bufptr get_buf(poolptr pp);
void put_buf(poolptr pp, bufptr bp);
int init_fifo(fifoptr fp);
bufptr read_fifo(fifoptr fp);
void write_fifo(fifoptr fp, bufptr bp);
void send_message(fifoptr fp,bufptr bp);
bufptr receive_message(fifoptr fp);
void prepare_message(bufptr buf,int source,int destination,int message_type);


char * message_to_string(int message);

//Flooding Thread implementation
//Works like this;
//While thread working is TRUE
//    Receive a Message From My Buffer
//    Make a transition according to received message
void * thread_impl(void *me);

void transition(int my_id,bufptr buf);

void multicast_to_neighbors(int my_id);

//Join Threads 
void join_threads();

void new_round_starter();


//Creates the system processes
//Gets Buffer
//Thread attributes
//Creates threads
//Prepare a message and send
//Join Threads
void start_threads();

//Prepares message buffer
//Sets the source
//Sets the destination
//Sets the message type
void prepare_message(bufptr buf,int source,int destination,int message_type);
